#ifndef __CAutoAnimation__
#define __CAutoAnimation__

#include "CAnimation.hpp"
#include "../Basics/ITimedObject.hpp"

//	===========================================================================

using Exponent::GUI::Controls::CAnimation;
using Exponent::GUI::Basics::ITimedObject;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CAutoAnimation CAutoAnimation.hpp
			 * @brief Displays an animation automatically looping at begining and end using timers
			 *
			 * @date 11/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CAutoAnimation.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CAutoAnimation : public CAnimation, public ITimedObject
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * @enum EAnimationStyle
				 * @brief Enumerators of animation styles
				 */
				enum EAnimationStyle
				{
					e_forward = 0,		/**< start to end */
					e_backward,			/**< end to start */
					e_bounce,			/**< forward then backward, in loop */
					e_forwardLoop,		/**< start to end, jump back to start and loop */
					e_backwardLoop,		/**< end to start, jump back to end and loop */
				};

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 */
				CAutoAnimation(IControlRoot *root, const long uniqueId, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CAutoAnimation();

//	===========================================================================

				/**
				 * Set the image
				 * @param theImage The image to display
				 * @param heightOfEachFrame The height of each frame of the animation strip
				 * @param numberOfFrames The total animtion length in frames
				 */
				virtual void setAnimationImage(IImage *theImage, const long heightOfEachFrame, const long numberOfFrames);

				/**
				 * Set the animation style
				 * @param style The style of animation
				 */
				virtual void setAnimationStyle(const EAnimationStyle style);

//	===========================================================================

				/**
				 * On expired increment value and redraw
				 */
				virtual void timerExpired();

				/**
				 * Get the id
				 * @retval long The timer identifier 
				 */
				virtual long getTimerId() const { return m_uniqueId; }

//	===========================================================================

				/**
				 * Start the animation
				 * @param updateRateInMillseconds Time in msec between update calls
				 */
				virtual void startAnimation(const long updateRateInMillseconds);

				/**
				 * Stop the animation
				 */
				virtual void stopAnimation();

//	===========================================================================

			protected:

//	===========================================================================

				double m_stepIncrement;					/**< Size of the increment for each timer update */
				EAnimationStyle m_animationStyle;		/**< Style of animation */
				bool m_forward;							/**< Currently going forward? */
			};
		}
	}
}
#endif	// End of CAutoAnimation.hpp